/******************************************************************************************
Filename		:  	CR_APPL_INDS.SQL
Release 		:  	STORET c2.0.5
SIR			:  	
Description		:  	Creates STORET and STORET1 indexes that are used by ETL.
Author			:  	Ganesh Thadkamalla
Date			: 	June, 09 2005

Comments		:  	"ORA-00955: name is already used by an existing object" is expected if index exist.
******************************************************************************************/
SPOOL CR_APPL_INDS.LOG

Prompt STORET indexes

--DBMS_METADATA.GET_DDL('INDEX','IBIOPT01','STORET')                              
                                                                                
  CREATE UNIQUE INDEX "STORET"."IBIOPT01" ON 
  "STORET"."TSRBIOPT" ("TSRBIOPT_IS_NUMBER", "TSRBIOPT_ORG_ID")                                                      
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 532480 NEXT 49152 MINEXTENTS 1 MAXEXTENTS 2147483645          
  PCTINCREASE 20 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)             
  TABLESPACE "STORET_INDS"   ;                                                   
                                                                                
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','ICALT01','STORET')                               

                                                                                
  CREATE UNIQUE INDEX "STORET"."ICALT01" ON 
  "STORET"."TSRCALT" ("TSRCALT_IS_NUMBER", "TSRCALT_ORG_ID")                                                          
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 163840 NEXT 49152 MINEXTENTS 1 MAXEXTENTS 2147483645          
  PCTINCREASE 20 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)             
  TABLESPACE "STORET_INDS"    ;                                                  
                                                                                
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','ICHALS01','STORET')                              

                                                                                
  CREATE UNIQUE INDEX "STORET"."ICHALS01" ON 
  "STORET"."TSRCHALS" ("TSRCHAR_IS_NUMBER", "TSRCHALS_IS_NUMBER", "TSRCHAR_ORG_ID")                                  
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 28712960 NEXT 24576 MINEXTENTS 1 MAXEXTENTS 2147483645        
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET_INDS" ;                                                     
                                                                                
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','ICHAR01','STORET')                               

                                                                                
  CREATE UNIQUE INDEX "STORET"."ICHAR01" ON 
  "STORET"."TSRCHAR" ("TSRCHAR_IS_NUMBER", "TSRCHAR_ORG_ID")                                                          
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 9265152 NEXT 24576 MINEXTENTS 1 MAXEXTENTS 2147483645         
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET_INDS" ;                                                     
                                                                                
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','IESTRY01','STORET')                              

                                                                                
  CREATE UNIQUE INDEX "STORET"."IESTRY01" ON 
  "STORET"."TSMESTRY" ("TSMESTRY_ORG_ID", "TSMESTRY_IS_NUMBER")                                                      
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 532480 NEXT 49152 MINEXTENTS 1 MAXEXTENTS 2147483645          
  PCTINCREASE 20 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)             
  TABLESPACE "STORET_INDS";                                                      
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','IFLDGR01','STORET')                              

                                                                                
  CREATE UNIQUE INDEX "STORET"."IFLDGR01" ON 
  "STORET"."TSRFLDGR" ("TSRFLDGR_IS_NUMBER", "TSRFLDGR_ORG_ID")                                                      
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 532480 NEXT 49152 MINEXTENTS 1 MAXEXTENTS 2147483645          
  PCTINCREASE 20 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)             
  TABLESPACE "STORET_INDS";                                                      
                                                                                
                                                                                
--DBMS_METADATA.GET_DDL('INDEX','IMATRX01','STORET')                              

                                                                                
  CREATE UNIQUE INDEX "STORET"."IMATRX01" ON 
  "STORET"."TSRMATRX" ("TSRMATRX_IS_NUMBER", "TSRMATRX_ORG_ID")                                                      
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 163840 NEXT 49152 MINEXTENTS 1 MAXEXTENTS 2147483645          
  PCTINCREASE 20 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)             
  TABLESPACE "STORET_INDS" ;                                                     
                                                                                
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','INAICS01','STORET')                              

                                                                                
  CREATE UNIQUE INDEX "STORET"."INAICS01" ON 
  "STORET"."TSMNAICS" ("TSMNAICS_IS_NUMBER", "TSMNAICS_ORG_ID")                                                      
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 163840 NEXT 147456 MINEXTENTS 1 MAXEXTENTS 2147483645         
  PCTINCREASE 20 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)             
  TABLESPACE "STORET_INDS" ;                                                     
                                                                                
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','IPRMVL01','STORET')                              

                                                                                
  CREATE UNIQUE INDEX "STORET"."IPRMVL01" ON 
  "STORET"."TSMPRMVL" ("TSMPRMVL_IS_NUMBER", "TSMPRMVL_ORG_ID")                                                      
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 532480 NEXT 49152 MINEXTENTS 1 MAXEXTENTS 2147483645          
  PCTINCREASE 20 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)             
  TABLESPACE "STORET_INDS";                                                      
                                                                                
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','IUOM01','STORET')                                

                                                                                
  CREATE UNIQUE INDEX "STORET"."IUOM01" ON
  "STORET"."TSRUOM" ("TSRUOM_IS_NUMBER", "TSRUOM_ORG_ID")                                                              
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 532480 NEXT 49152 MINEXTENTS 1 MAXEXTENTS 2147483645          
  PCTINCREASE 20 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)             
  TABLESPACE "STORET_INDS";        

--***************************************************

PROMPT STORET1 INDEXES
--DBMS_METADATA.GET_DDL('INDEX','IAAL02','STORET1')                               

  CREATE INDEX "STORET1"."IAAL02" ON 
  "STORET1"."TSRAAL" ("TSRFDACT_IS_NUMBER", "TSRFDACT_ORG_ID")                                                               
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 189194240 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645     
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS" ;
                                                                                
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','IALP01','STORET1')                               

                                                                                
  CREATE UNIQUE INDEX "STORET1"."IALP01" ON 
 "STORET1"."TSMALP" ("TSMALP_IS_NUMBER", "TSMALP_ORG_ID")                                                            
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 11018240 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645      
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"          ;                                           
                                                                                
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','IALP11','STORET1')                               

                                                                                
  CREATE INDEX "STORET1"."IALP11" ON
 "STORET1"."TSMALP" ("TSMSTATN_IS_NUMBER", "TSMSTATN_ORG_ID")                                                               
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 11018240 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645      
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"                 ;                                    
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','IANLPR01','STORET1')                             

                                                                                
  CREATE UNIQUE INDEX "STORET1"."IANLPR01" ON
 "STORET1"."TSRANLPR" ("TSRANLPR_IS_NUMBER", "TSRANLPR_ORG_ID")                                                    
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 25600000 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645      
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"        ;                                             
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','IBRG01','STORET1')                               

                                                                                
  CREATE UNIQUE INDEX "STORET1"."IBRG01" ON
 "STORET1"."TSRBRG" ("TSRBRG_IS_NUMBER", "TSRBRG_ORG_ID")                                                            
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 25600000 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645      
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"          ;                                           
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','IBRGI01','STORET1')                              

                                                                                
  CREATE UNIQUE INDEX "STORET1"."IBRGI01" ON
 "STORET1"."TSRBRGI" ("TSRBRGI_IS_NUMBER", "TSRBRGI_ORG_ID")                                                        
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 25600000 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645      
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"         ;                                            
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','ICHGRP01','STORET1')                             

                                                                                
  CREATE UNIQUE INDEX "STORET1"."ICHGRP01" ON
 "STORET1"."TSRCHGRP" ("TSRCHGRP_IS_NUMBER", "TSRCHGRP_ORG_ID")                                                    
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 25600000 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645      
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"        ;                                             
                                                                                
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','ICITN01','STORET1')                              

                                                                                
  CREATE UNIQUE INDEX "STORET1"."ICITN01" ON
 "STORET1"."TSRCITN" ("TSRCITN_IS_NUMBER", "TSRCITN_ORG_ID")                                                        
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 25600000 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645      
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"         ;                                            
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','ICLDES01','STORET1')                             

                                                                                
  CREATE UNIQUE INDEX "STORET1"."ICLDES01" ON
 "STORET1"."TSRCLDES" ("TSRRSULT_ORG_ID", "TSRRSULT_IS_NUMBER")                                                    
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 25600000 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645      
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"        ;                                             
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','IDQL01','STORET1')                               

                                                                                
  CREATE UNIQUE INDEX "STORET1"."IDQL01" ON
 "STORET1"."TSRDQL" ("TSRRSULT_IS_NUMBER", "TSRRSULT_ORG_ID")                                                        
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 257884160 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645     
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"          ;                                           
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','IEOD01','STORET1')                               

                                                                                
  CREATE UNIQUE INDEX "STORET1"."IEOD01" ON
 "STORET1"."TSREOD" ("TSRFDACT_IS_NUMBER", "TSRFDACT_ORG_ID")                                                        
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 25600000 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645      
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"          ;                                           
                                                                                
                                                                                
--DBMS_METADATA.GET_DDL('INDEX','IFAFSA01','STORET1')                             

                                                                                
  CREATE UNIQUE INDEX "STORET1"."IFAFSA01" ON
 "STORET1"."TSRFAFSA" ("TSRFDACT_IS_NUMBER", "TSRFDACT_ORG_ID", "TSRFDSET_IS_NUMBER", "TSRFDSET_ORG_ID")           
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 25600000 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645      
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"        ;                                             
                                                                                
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','IFAPRA01','STORET1')                             

                                                                                
  CREATE UNIQUE INDEX "STORET1"."IFAPRA01" ON
 "STORET1"."TSRFAPRA" ("TSRFDACT_IS_NUMBER", "TSRFDACT_ORG_ID", "TSMPROJ_IS_NUMBER", "TSMPROJ_ORG_ID")             
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 277954560 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645     
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"        ;                                             
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','IFDACT01','STORET1')                             

                                                                                
  CREATE UNIQUE INDEX "STORET1"."IFDACT01" ON
 "STORET1"."TSRFDACT" ("TSRFDACT_IS_NUMBER", "TSRFDACT_ORG_ID")                                                    
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 183009280 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645     
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"        ;                                             
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','IFDACT08','STORET1')                             

                                                                                
  CREATE INDEX "STORET1"."IFDACT08" ON
 "STORET1"."TSRFDACT" ("TSRFDACT1IS_NUMBER", "TSRFDACT1ORG_ID")                                                           
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 1597440 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645       
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"               ;                                      
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','IFLDPR01','STORET1')                             

                                                                                
  CREATE UNIQUE INDEX "STORET1"."IFLDPR01" ON
 "STORET1"."TSRFLDPR" ("TSRFLDPR_IS_NUMBER", "TSRFLDPR_ORG_ID")                                                    
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 25600000 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645      
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"        ;                                             
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','IFNA01','STORET1')                               

                                                                                
  CREATE UNIQUE INDEX "STORET1"."IFNA01" ON
 "STORET1"."TSMFNA" ("TSMSTATN_IS_NUMBER", "TSMSTATN_ORG_ID", "TSMNAICS_IS_NUMBER", "TSMNAICS_ORG_ID")               
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 10485760 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645      
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"          ;                                           
                                                                                
                                                                                
--DBMS_METADATA.GET_DDL('INDEX','IGRCFG01','STORET1')                             

                                                                                
  CREATE UNIQUE INDEX "STORET1"."IGRCFG01" ON
 "STORET1"."TSRGRCFG" ("TSRGRCFG_IS_NUMBER", "TSRGRCFG_ORG_ID")                                                    
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 25600000 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645      
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"        ;                                             
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','IHCSC01','STORET1')                              

                                                                                
  CREATE UNIQUE INDEX "STORET1"."IHCSC01" ON
 "STORET1"."TSRHCSC" ("TSRHCSC_IS_NUMBER", "TSRHCSC_ORG_ID")                                                        
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 25600000 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645      
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"         ;                                            
                                                                                
                                                                                
--DBMS_METADATA.GET_DDL('INDEX','ILAB01','STORET1')                               

                                                                                
  CREATE UNIQUE INDEX "STORET1"."ILAB01" ON
 "STORET1"."TSRLAB" ("TSRLAB_IS_NUMBER", "TSRLAB_ORG_ID")                                                            
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 25600000 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645      
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"          ;                                           
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','IOPPRD01','STORET1')                             

                                                                                
  CREATE UNIQUE INDEX "STORET1"."IOPPRD01" ON
 "STORET1"."TSROPPRD" ("TSROPPRD_ORG_ID", "TSROPPRD_IS_NUMBER")                                                    
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 25600000 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645      
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"        ;                                             
                                                                                
                                                                                
--DBMS_METADATA.GET_DDL('INDEX','IORGAN01','STORET1')                             

                                                                                
  CREATE UNIQUE INDEX "STORET1"."IORGAN01" ON
 "STORET1"."TSMORGAN" ("TSMORGAN_IS_NUMBER")                                                                       
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 532480 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645        
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"        ;                                             
                                                                                
                                                                                
--DBMS_METADATA.GET_DDL('INDEX','IORGAN02','STORET1')                             

                                                                                
  CREATE INDEX "STORET1"."IORGAN02" ON
 "STORET1"."TSMORGAN" ("ORG_ID")          
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 532480 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645        
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"               ;                                      
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','IPROJ01','STORET1')                              

                                                                                
  CREATE UNIQUE INDEX "STORET1"."IPROJ01" ON
 "STORET1"."TSMPROJ" ("TSMPROJ_IS_NUMBER", "TSMPROJ_ORG_ID")                                                        
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 25600000 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645      
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"         ;                                            
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','IPSA01','STORET1')                               

                                                                                
  CREATE UNIQUE INDEX "STORET1"."IPSA01" ON
 "STORET1"."TSMPSA" ("TSMSTATN_IS_NUMBER", "TSMSTATN_ORG_ID", "TSMPROJ_IS_NUMBER", "TSMPROJ_ORG_ID")                 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 25600000 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645      
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"          ;                                           
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','IRLRA01','STORET1')                              

                                                                                
  CREATE UNIQUE INDEX "STORET1"."IRLRA01" ON
 "STORET1"."TSRRLRA" ("TSRRSULT_IS_NUMBER", "TSRRSULT_ORG_ID", "TSRLBRMK_IS_NUMBER", "TSRLBRMK_ORG_ID")             
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 25600000 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645      
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"         ;                                            
                                                                                
                                                                                
--DBMS_METADATA.GET_DDL('INDEX','IRRCI01','STORET1')                              

                                                                                
  CREATE UNIQUE INDEX "STORET1"."IRRCI01" ON
 "STORET1"."TSRRCI" ("TSRRSULT_ORG_ID", "TSRRSULT_IS_NUMBER")                                                       
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 25600000 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645      
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"         ;                                            
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','IRSULT01','STORET1')                             

                                                                                
  CREATE UNIQUE INDEX "STORET1"."IRSULT01" ON
 "STORET1"."TSRRSULT" ("TSRRSULT_IS_NUMBER", "TSRRSULT_ORG_ID")                                                    
  PCTFREE 5 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                          
  STORAGE(INITIAL 1179729920 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645    
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"        ;                                             
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','IRSULT07','STORET1')                             

                                                                                
  CREATE INDEX "STORET1"."IRSULT07" ON
 "STORET1"."TSRRSULT" ("TSRBRG_IS_NUMBER", "TSRBRG_ORG_ID")                                                               
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 38748160 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645      
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"               ;                                      
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','IRSULT08','STORET1')                             

                                                                                
  CREATE INDEX "STORET1"."IRSULT08" ON
 "STORET1"."TSRRSULT" ("TSRBRGI_IS_NUMBER", "TSRBRGI_ORG_ID")                                                             
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 5734400 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645       
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"               ;                                      
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','IRSULT11','STORET1')                             

                                                                                
  CREATE INDEX "STORET1"."IRSULT11" ON
 "STORET1"."TSRRSULT" ("TSRFDACT_IS_NUMBER", "TSRFDACT_ORG_ID")                                                           
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 1189765120 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645    
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"               ;                                      
                                                                                
                                                                                
--DBMS_METADATA.GET_DDL('INDEX','IRSULT14','STORET1')                             

                                                                                
  CREATE INDEX "STORET1"."IRSULT14" ON
 "STORET1"."TSRRSULT" ("TSRDLIN_IS_NUMBER", "TSRDLIN_ORG_ID")                                                             
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 165355520 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645     
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"               ;                                      
                                                                                
                                                                                
--DBMS_METADATA.GET_DDL('INDEX','ISTATN01','STORET1')                             

                                                                                
  CREATE UNIQUE INDEX "STORET1"."ISTATN01" ON
 "STORET1"."TSMSTATN" ("TSMSTATN_IS_NUMBER", "TSMSTATN_ORG_ID")                                                    
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 104857600 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645     
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"        ;                                             
                                                                                
                                                                                
--DBMS_METADATA.GET_DDL('INDEX','ISTVST01','STORET1')                             

                                                                                
  CREATE UNIQUE INDEX "STORET1"."ISTVST01" ON
 "STORET1"."TSRSTVST" ("TSRSTVST_IS_NUMBER", "TSRSTVST_ORG_ID")                                                    
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 79380480 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645      
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"        ;                                             
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','ITNOD01','STORET1')                              

                                                                                
  CREATE UNIQUE INDEX "STORET1"."ITNOD01" ON
 "STORET1"."TSRTNOD" ("TSRFDACT_IS_NUMBER", "TSRFDACT_ORG_ID")                                                      
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 25600000 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645      
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"         ;                                            
                                                                                

--DBMS_METADATA.GET_DDL('INDEX','ITOD01','STORET1')                               

                                                                                
  CREATE UNIQUE INDEX "STORET1"."ITOD01" ON
 "STORET1"."TSRTOD" ("TSRFDACT_IS_NUMBER", "TSRFDACT_ORG_ID")                                                        
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS                         
  STORAGE(INITIAL 25600000 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645      
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              
  TABLESPACE "STORET1_INDS"          ;                                           
                                                                                
                                                                                
SPOOL OFF;
